package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.json.GroupListView;
import gov.va.vinci.dart.json.GroupView;
import gov.va.vinci.dart.json.atom.AtomLinkFactory;
import gov.va.vinci.dart.json.atom.LinkListView;
import gov.va.vinci.dart.json.atom.LinkView;
import gov.va.vinci.dart.json.atom.Relation;

import java.util.Collection;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupListViewBuilder {
	@Autowired
	private AtomLinkFactory linkFactory;
	
	public GroupListView build(final Collection<Group> groupList, final boolean bIncludeLinks) {
		GroupListView result = new GroupListView();
		
		if( groupList != null ) {
			for (Group group : groupList) {
				GroupView view = new GroupView();
				view.setId(group.getId());
				view.setName(group.getName());
				
				if( bIncludeLinks == true ) {
					LinkListView linkListView = new LinkListView();
					view.setLinks(linkListView);
					
					LinkView link = linkFactory.buildLink("/groups/" + group.getId(), Relation.SELF);
					linkListView.getLink().add(link);
					link = linkFactory.buildLink("/groups/" + group.getId() + "/tasks", Relation.RELATED);
					linkListView.getLink().add(link);
				}

				result.getGroups().add(view);
			}//end for
		}//end if
		
		return result;
	}
}
